"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentTypeRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectVersioningUtils = require("@kbn/object-versioning-utils");
var _content_type = require("./content_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ContentTypeRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "types", new Map());
  }
  register(definition) {
    var _definition$version;
    if (this.types.has(definition.id)) {
      throw new Error(`Content type with id "${definition.id}" already registered.`);
    }
    const {
      result,
      value
    } = (0, _objectVersioningUtils.validateVersion)((_definition$version = definition.version) === null || _definition$version === void 0 ? void 0 : _definition$version.latest);
    if (!result) {
      var _definition$version2;
      throw new Error(`Invalid version [${(_definition$version2 = definition.version) === null || _definition$version2 === void 0 ? void 0 : _definition$version2.latest}]. Must be an integer.`);
    }
    if (value < 1) {
      throw new Error(`Version must be >= 1`);
    }
    const type = new _content_type.ContentType({
      ...definition,
      version: {
        ...definition.version,
        latest: value
      }
    });
    this.types.set(type.id, type);
    return type;
  }
  get(id) {
    return this.types.get(id);
  }
  getAll() {
    return Array.from(this.types.values());
  }
}
exports.ContentTypeRegistry = ContentTypeRegistry;