"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Alias = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class Alias {
  constructor() {
    (0, _defineProperty2.default)(this, "perAliasIndexes", {});
    (0, _defineProperty2.default)(this, "getIndices", (includeAliases, collaborator) => {
      const ret = [];
      const perIndexTypes = collaborator.perIndexTypes;
      Object.keys(perIndexTypes).forEach(index => {
        // ignore .ds* indices in the suggested indices list.
        if (!index.startsWith('.ds')) {
          ret.push(index);
        }
      });
      if (typeof includeAliases === 'undefined' ? true : includeAliases) {
        Object.keys(this.perAliasIndexes).forEach(alias => {
          ret.push(alias);
        });
      }
      return ret;
    });
    (0, _defineProperty2.default)(this, "loadAliases", (aliases, collaborator) => {
      this.perAliasIndexes = {};
      const perIndexTypes = collaborator.perIndexTypes;
      Object.entries(aliases).forEach(([index, indexAliases]) => {
        // verify we have an index defined. useful when mapping loading is disabled
        perIndexTypes[index] = perIndexTypes[index] || {};
        Object.keys(indexAliases.aliases || {}).forEach(alias => {
          if (alias === index) {
            return;
          } // alias which is identical to index means no index.
          let curAliases = this.perAliasIndexes[alias];
          if (!curAliases) {
            curAliases = [];
            this.perAliasIndexes[alias] = curAliases;
          }
          curAliases.push(index);
        });
      });
      const includeAliases = false;
      this.perAliasIndexes._all = this.getIndices(includeAliases, collaborator);
    });
    (0, _defineProperty2.default)(this, "clearAliases", () => {
      this.perAliasIndexes = {};
    });
  }
}
exports.Alias = Alias;