"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ByteSizeType = void 0;
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _byte_size_value = require("../byte_size_value");
var _errors = require("../errors");
var _internals = require("../internals");
var _type = require("./type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ByteSizeType extends _type.Type {
  constructor(options = {}) {
    let schema = _internals.internals.bytes();
    if (options.min !== undefined) {
      schema = schema.min(options.min);
    }
    if (options.max !== undefined) {
      schema = schema.max(options.max);
    }
    super(schema, {
      defaultValue: (0, _byte_size_value.ensureByteSizeValue)(options.defaultValue),
      validate: options.validate
    });
  }
  handleError(type, {
    limit,
    message,
    value
  }, path) {
    switch (type) {
      case 'any.required':
      case 'bytes.base':
        return `expected value of type [ByteSize] but got [${(0, _typeDetect.default)(value)}]`;
      case 'bytes.parse':
        return new _errors.SchemaTypeError(message, path);
      case 'bytes.min':
        return `Value must be equal to or greater than [${limit.toString()}]`;
      case 'bytes.max':
        return `Value must be equal to or less than [${limit.toString()}]`;
    }
  }
}
exports.ByteSizeType = ByteSizeType;