"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArrayType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _internals = require("../internals");
var _type = require("./type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ArrayType extends _type.Type {
  constructor(type, options = {}) {
    let schema = _internals.internals.array().items(type.getSchema().optional()).sparse(false);
    if (options.minSize !== undefined) {
      schema = schema.min(options.minSize);
    }
    if (options.maxSize !== undefined) {
      schema = schema.max(options.maxSize);
    }

    // Only set stripUnknown if we have an explicit value of unknowns
    const {
      unknowns
    } = options;
    if (unknowns) {
      schema = schema.options({
        stripUnknown: {
          objects: unknowns === 'ignore'
        }
      });
    }
    super(schema, options);
    (0, _defineProperty2.default)(this, "arrayType", void 0);
    (0, _defineProperty2.default)(this, "arrayOptions", void 0);
    this.arrayType = type;
    this.arrayOptions = options;
  }
  extendsDeep(options) {
    return new ArrayType(this.arrayType.extendsDeep(options), this.arrayOptions);
  }
  handleError(type, {
    limit,
    reason,
    value
  }) {
    switch (type) {
      case 'any.required':
      case 'array.base':
        return `expected value of type [array] but got [${(0, _typeDetect.default)(value)}]`;
      case 'array.sparse':
        return `sparse array are not allowed`;
      case 'array.parse':
        return `could not parse array value from json input`;
      case 'array.min':
        return `array size is [${value.length}], but cannot be smaller than [${limit}]`;
      case 'array.max':
        return `array size is [${value.length}], but cannot be greater than [${limit}]`;
      case 'array.includesOne':
        return reason[0];
    }
  }
}
exports.ArrayType = ArrayType;