"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDetectionEngineAlertsCountByRuleTags = exports.defineGetDetectionEngineAlertsStatus = void 0;
var _configSchema = require("@kbn/config-schema");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ALERTS_INDEX = '.alerts-security.alerts-default';
const getDetectionEngineAlertsCountByRuleTags = async (esClient, tags) => {
  return await esClient.search({
    size: 0,
    query: {
      bool: {
        filter: [{
          term: {
            'kibana.alert.rule.tags': 'Cloud Security'
          }
        }, ...tags.map(tag => ({
          term: {
            'kibana.alert.rule.tags': tag
          }
        }))]
      }
    },
    sort: '@timestamp:desc',
    index: DEFAULT_ALERTS_INDEX
  });
};
exports.getDetectionEngineAlertsCountByRuleTags = getDetectionEngineAlertsCountByRuleTags;
const getDetectionEngineAlertsStatus = async (esClient, tags) => {
  var _alertsCountByTags$hi;
  const alertsCountByTags = await getDetectionEngineAlertsCountByRuleTags(esClient, tags);
  const total = typeof alertsCountByTags.hits.total === 'number' ? alertsCountByTags.hits.total : (_alertsCountByTags$hi = alertsCountByTags.hits.total) === null || _alertsCountByTags$hi === void 0 ? void 0 : _alertsCountByTags$hi.value;
  return {
    total
  };
};
const defineGetDetectionEngineAlertsStatus = router => router.versioned.get({
  access: 'internal',
  path: _constants.GET_DETECTION_RULE_ALERTS_STATUS_PATH,
  security: {
    authz: {
      requiredPrivileges: ['cloud-security-posture-read']
    }
  }
}).addVersion({
  version: _constants.DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION,
  validate: {
    request: {
      query: _configSchema.schema.object({
        tags: _configSchema.schema.arrayOf(_configSchema.schema.string())
      })
    }
  }
}, async (context, request, response) => {
  const requestBody = request.query;
  const cspContext = await context.csp;
  try {
    const alerts = await getDetectionEngineAlertsStatus(cspContext.esClient.asCurrentUser, requestBody.tags);
    return response.ok({
      body: alerts
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch csp rules templates ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGetDetectionEngineAlertsStatus = defineGetDetectionEngineAlertsStatus;