"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityStatistics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_navigate_findings = require("@kbn/cloud-security-posture/src/hooks/use_navigate_findings");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _vuln_counter_card = require("../../components/vuln_counter_card");
var _use_vulnerability_dashboard_api = require("../../common/api/use_vulnerability_dashboard_api");
var _compact_formatted_number = require("../../components/compact_formatted_number");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnerabilityStatistics = () => {
  const navToVulnerabilities = (0, _use_navigate_findings.useNavigateNativeVulnerabilities)();
  const getVulnerabilityDashboard = (0, _use_vulnerability_dashboard_api.useVulnerabilityDashboardApi)();
  const stats = (0, _react.useMemo)(() => {
    var _getVulnerabilityDash, _getVulnerabilityDash2, _getVulnerabilityDash3, _getVulnerabilityDash4, _getVulnerabilityDash5;
    return [{
      id: 'critical-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash === void 0 ? void 0 : _getVulnerabilityDash.cnvmStatistics.criticalCount
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: (0, _cloudSecurityPosture.getSeverityStatusColor)(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.CRITICAL),
        textSize: 'xs'
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.criticalTitle', {
        defaultMessage: 'Critical'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.CRITICAL
        });
      }
    }, {
      id: 'high-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash2 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash2 === void 0 ? void 0 : _getVulnerabilityDash2.cnvmStatistics.highCount
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: (0, _cloudSecurityPosture.getSeverityStatusColor)(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.HIGH),
        textSize: 'xs'
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.highTitle', {
        defaultMessage: 'High'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.HIGH
        });
      }
    }, {
      id: 'medium-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash3 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash3 === void 0 ? void 0 : _getVulnerabilityDash3.cnvmStatistics.mediumCount
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: (0, _cloudSecurityPosture.getSeverityStatusColor)(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.MEDIUM),
        textSize: 'xs'
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.mediumTitle', {
        defaultMessage: 'Medium'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.MEDIUM
        });
      }
    }, {
      id: 'cloud-regions-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash4 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash4 === void 0 ? void 0 : _getVulnerabilityDash4.cnvmStatistics.cloudAccounts
      }),
      description: _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.cloudRegionTitle', {
        defaultMessage: 'Cloud Accounts'
      })
    }, {
      id: 'assets-scanned-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash5 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash5 === void 0 ? void 0 : _getVulnerabilityDash5.cnvmStatistics.resourcesScanned
      }),
      description: _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.resourcesScannedTitle', {
        defaultMessage: 'Resources Scanned'
      })
    }];
  }, [getVulnerabilityDashboard.data, navToVulnerabilities]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, stats.map(stat => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: stat.id
  }, /*#__PURE__*/_react.default.createElement(_vuln_counter_card.VulnCounterCard, stat))));
};
exports.VulnerabilityStatistics = VulnerabilityStatistics;