"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityJsonTab = void 0;
var _codeEditor = require("@kbn/code-editor");
var _react = _interopRequireDefault(require("react"));
var _monaco = require("@kbn/monaco");
var _test_subjects = require("../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnerabilityJsonTab = ({
  vulnerabilityRecord
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      inset: 0
    },
    "data-test-subj": _test_subjects.JSON_TAB_VULNERABILITY_FLYOUT
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    enableFindAction: true,
    isCopyable: true,
    allowFullScreen: true,
    languageId: _monaco.XJsonLang.ID,
    value: JSON.stringify(vulnerabilityRecord, null, 2),
    options: {
      readOnly: true,
      lineNumbers: 'on',
      folding: true
    }
  }));
};
exports.VulnerabilityJsonTab = VulnerabilityJsonTab;