"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cspIntegrationDocsNavigation = exports.cloudPosturePages = exports.benchmarksNavigation = void 0;
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _navigation = require("@kbn/cloud-security-posture/src/constants/navigation");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CSPM_DASHBOARD_TAB_NAME = 'Cloud';
const KSPM_DASHBOARD_TAB_NAME = 'Kubernetes';
const cloudPosturePages = exports.cloudPosturePages = {
  dashboard: {
    name: _navigation.NAV_ITEMS_NAMES.DASHBOARD,
    path: `${_cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH}/dashboard`,
    id: 'cloud_security_posture-dashboard'
  },
  cspm_dashboard: {
    name: CSPM_DASHBOARD_TAB_NAME,
    path: `${_cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH}/dashboard/${_cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE}`,
    id: 'cloud_security_posture-cspm-dashboard'
  },
  kspm_dashboard: {
    name: KSPM_DASHBOARD_TAB_NAME,
    path: `${_cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH}/dashboard/${_cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE}`,
    id: 'cloud_security_posture-kspm-dashboard'
  },
  vulnerability_dashboard: {
    name: _navigation.NAV_ITEMS_NAMES.VULNERABILITY_DASHBOARD,
    path: `${_cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH}/vulnerability_dashboard`,
    id: 'cloud_security_posture-vulnerability_dashboard'
  },
  findings: {
    name: _navigation.NAV_ITEMS_NAMES.FINDINGS,
    path: `${_cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH}/findings`,
    id: 'cloud_security_posture-findings'
  },
  benchmarks: {
    name: _navigation.NAV_ITEMS_NAMES.BENCHMARKS,
    path: `${_cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH}/benchmarks`,
    id: 'cloud_security_posture-benchmarks'
  }
};
const benchmarksNavigation = exports.benchmarksNavigation = {
  rules: {
    name: _navigation.NAV_ITEMS_NAMES.RULES,
    path: `${_cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH}/benchmarks/:benchmarkId/:benchmarkVersion/rules/:ruleId?`,
    id: 'cloud_security_posture-benchmarks-rules'
  }
};
const ELASTIC_BASE_SHORT_URL = 'https://ela.st';
const cspIntegrationDocsNavigation = exports.cspIntegrationDocsNavigation = {
  kspm: {
    overviewPath: `${ELASTIC_BASE_SHORT_URL}/${_cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE}`,
    getStartedPath: `${ELASTIC_BASE_SHORT_URL}/${_cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE}-get-started`
  },
  cspm: {
    overviewPath: `${ELASTIC_BASE_SHORT_URL}/${_cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE}`,
    getStartedPath: `${ELASTIC_BASE_SHORT_URL}/${_cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE}-get-started`,
    awsGetStartedPath: `https://www.elastic.co/guide/en/security/current/cspm-get-started.html`,
    gcpGetStartedPath: `https://www.elastic.co/guide/en/security/current/cspm-get-started-gcp.html`,
    azureGetStartedPath: `https://www.elastic.co/guide/en/security/current/cspm-get-started-azure.html`
  },
  cnvm: {
    overviewPath: `${ELASTIC_BASE_SHORT_URL}/${_constants.CNVM_POLICY_TEMPLATE}`
  }
};