"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistTokenCloudData = void 0;
var _react = _interopRequireDefault(require("fast-deep-equal/react"));
var _server = require("@kbn/core/server");
var _saved_objects = require("../saved_objects");
var _constants = require("../routes/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const persistTokenCloudData = async (savedObjectsClient, {
  logger,
  returnError,
  onboardingToken,
  solutionType,
  security
}) => {
  var _cloudDataSo, _cloudDataSo$attribut;
  let cloudDataSo = null;
  try {
    cloudDataSo = await savedObjectsClient.get(_saved_objects.CLOUD_DATA_SAVED_OBJECT_TYPE, _constants.CLOUD_DATA_SAVED_OBJECT_ID);
  } catch (error) {
    if (_server.SavedObjectsErrorHelpers.isNotFoundError(error)) {
      cloudDataSo = null;
    } else {
      if (returnError) {
        throw error;
      } else if (logger) {
        logger.error(error);
      }
    }
  }
  const securityAttributes = (_cloudDataSo = cloudDataSo) === null || _cloudDataSo === void 0 ? void 0 : (_cloudDataSo$attribut = _cloudDataSo.attributes.onboardingData) === null || _cloudDataSo$attribut === void 0 ? void 0 : _cloudDataSo$attribut.security;
  try {
    var _cloudDataSo2;
    if ((onboardingToken || security) && cloudDataSo === null) {
      await savedObjectsClient.create(_saved_objects.CLOUD_DATA_SAVED_OBJECT_TYPE, {
        onboardingData: {
          solutionType: solutionType,
          token: onboardingToken !== null && onboardingToken !== void 0 ? onboardingToken : '',
          security
        }
      }, {
        id: _constants.CLOUD_DATA_SAVED_OBJECT_ID
      });
    } else if (cloudDataSo && (((_cloudDataSo2 = cloudDataSo) === null || _cloudDataSo2 === void 0 ? void 0 : _cloudDataSo2.attributes.onboardingData.token) !== onboardingToken || !(0, _react.default)(securityAttributes, security))) {
      var _ref, _cloudDataSo3, _cloudDataSo4;
      await savedObjectsClient.update(_saved_objects.CLOUD_DATA_SAVED_OBJECT_TYPE, _constants.CLOUD_DATA_SAVED_OBJECT_ID, {
        onboardingData: {
          solutionType: (_ref = solutionType) !== null && _ref !== void 0 ? _ref : (_cloudDataSo3 = cloudDataSo) === null || _cloudDataSo3 === void 0 ? void 0 : _cloudDataSo3.attributes.onboardingData.solutionType,
          token: onboardingToken !== null && onboardingToken !== void 0 ? onboardingToken : (_cloudDataSo4 = cloudDataSo) === null || _cloudDataSo4 === void 0 ? void 0 : _cloudDataSo4.attributes.onboardingData.token,
          security: security !== null && security !== void 0 ? security : securityAttributes
        }
      });
    }
  } catch (error) {
    if (returnError) {
      throw error;
    } else if (logger) {
      logger.error(error);
    }
  }
};
exports.persistTokenCloudData = persistTokenCloudData;