"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectorConditionsMap = exports.DefaultProcessSelector = exports.DefaultProcessResponse = exports.DefaultFileSelector = exports.DefaultFileResponse = void 0;
var i18n = _interopRequireWildcard(require("./components/control_general_view/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * cloud_defend plugin types
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

/**
 * cloud_defend/control types
 */

/*
 * 'stringArray' uses a EuiComboBox
 * 'flag' is a boolean value which is always 'true'
 * 'boolean' can be true or false
 */

// used to determine UX control and allowed values for each condition
const SelectorConditionsMap = exports.SelectorConditionsMap = {
  containerImageFullName: {
    type: 'stringArray',
    pattern: '^(?:\\[[a-fA-F0-9:]+\\]|(?:[a-zA-Z0-9-](?:\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$',
    patternError: i18n.errorInvalidFullContainerImageName,
    not: ['containerImageName']
  },
  containerImageName: {
    type: 'stringArray',
    pattern: '^([a-z0-9]+(?:[._-][a-z0-9]+)*)$',
    not: ['containerImageFullName']
  },
  containerImageTag: {
    type: 'stringArray'
  },
  kubernetesClusterId: {
    type: 'stringArray'
  },
  kubernetesClusterName: {
    type: 'stringArray'
  },
  kubernetesNamespace: {
    type: 'stringArray'
  },
  kubernetesPodName: {
    type: 'stringArray'
  },
  kubernetesPodLabel: {
    type: 'stringArray',
    pattern: '^([a-zA-Z0-9\\.\\-]+\\/)?[a-zA-Z0-9\\.\\-]+:[a-zA-Z0-9\\.\\-\\_]*\\*?$',
    patternError: i18n.errorInvalidPodLabel
  },
  operation: {
    type: 'stringArray',
    values: {
      file: ['createExecutable', 'modifyExecutable', 'createFile', 'modifyFile', 'deleteFile'],
      process: ['fork', 'exec']
    }
  },
  targetFilePath: {
    selectorType: 'file',
    type: 'stringArray',
    maxValueBytes: 255,
    pattern: '^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$',
    patternError: i18n.errorInvalidTargetFilePath
  },
  ignoreVolumeFiles: {
    selectorType: 'file',
    type: 'flag',
    not: ['ignoreVolumeMounts']
  },
  ignoreVolumeMounts: {
    selectorType: 'file',
    type: 'flag',
    not: ['ignoreVolumeFiles']
  },
  processExecutable: {
    selectorType: 'process',
    type: 'stringArray',
    not: ['processName'],
    pattern: '^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$',
    patternError: i18n.errorInvalidProcessExecutable
  },
  processName: {
    selectorType: 'process',
    type: 'stringArray',
    not: ['processExecutable'],
    maxValueBytes: 15
  },
  sessionLeaderInteractive: {
    selectorType: 'process',
    type: 'boolean'
  }
};
const DefaultFileSelector = exports.DefaultFileSelector = {
  type: 'file',
  name: 'Untitled',
  operation: ['createExecutable', 'modifyExecutable']
};
const DefaultProcessSelector = exports.DefaultProcessSelector = {
  type: 'process',
  name: 'Untitled',
  operation: ['fork', 'exec']
};
const DefaultFileResponse = exports.DefaultFileResponse = {
  type: 'file',
  match: [],
  actions: ['alert']
};
const DefaultProcessResponse = exports.DefaultProcessResponse = {
  type: 'process',
  match: [],
  actions: ['alert']
};