"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    border
  } = euiTheme;
  return (0, _react.useMemo)(() => {
    const yamlEditor = {
      height: '500px',
      border: border.thin
    };

    // for some reason, switching back to monaco (by virtue of including the editor when yaml view selector, causes the editor not not update properly when switching views.
    // instead I just hide it visually, and show when we switch back which seems
    // to fix the issue.
    const hide = {
      visibility: 'hidden',
      position: 'absolute'
    };
    return {
      yamlEditor,
      hide
    };
  }, [border.thin]);
};
exports.useStyles = useStyles;