"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockPointInTimeFinder = exports.createSavedObjectReferences = exports.createSOFindResponse = exports.createJiraConnector = exports.createExternalService = exports.createErrorSO = exports.createESJiraConnector = exports.createConnectorObject = exports.createCaseSavedObjectResponse = exports.basicESCaseFields = exports.basicCaseFields = void 0;
var _server = require("@kbn/actions-plugin/server");
var _domain = require("../../common/types/domain");
var _constants = require("../common/constants");
var _constants2 = require("../../common/constants");
var _utils = require("../common/utils");
var _case = require("../common/types/case");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is only a utility interface to help with constructing test cases. After the migration, the ES format will no longer
 * have the id field. Instead it will be moved to the references array.
 */

/**
 * This file contains utility functions to aid unit test development
 */

/**
 * Create an Elasticsearch jira connector.
 *
 * @param overrides fields used to override the default jira connector
 * @returns a jira Elasticsearch connector (it has key value pairs for the fields) by default
 */
const createESJiraConnector = overrides => {
  return {
    id: '1',
    name: _domain.ConnectorTypes.jira,
    fields: [{
      key: 'issueType',
      value: 'bug'
    }, {
      key: 'priority',
      value: 'high'
    }, {
      key: 'parent',
      value: '2'
    }],
    type: _domain.ConnectorTypes.jira,
    ...overrides
  };
};

/**
 * Creates a jira CaseConnector (has the actual fields defined in the object instead of key value paris)
 * @param setFieldsToNull a flag that controls setting the fields property to null
 * @returns a jira connector
 */
exports.createESJiraConnector = createESJiraConnector;
const createJiraConnector = ({
  setFieldsToNull
} = {}) => {
  return {
    id: '1',
    name: _domain.ConnectorTypes.jira,
    type: _domain.ConnectorTypes.jira,
    fields: setFieldsToNull ? null : {
      issueType: 'bug',
      priority: 'high',
      parent: '2'
    }
  };
};
exports.createJiraConnector = createJiraConnector;
const createExternalService = overrides => ({
  connector_id: '100',
  connector_name: '.jira',
  external_id: '100',
  external_title: 'awesome',
  external_url: 'http://www.google.com',
  pushed_at: '2019-11-25T21:54:48.952Z',
  pushed_by: {
    full_name: 'elastic',
    email: 'testemail@elastic.co',
    username: 'elastic'
  },
  ...overrides
});
exports.createExternalService = createExternalService;
const basicESCaseFields = exports.basicESCaseFields = {
  closed_at: null,
  closed_by: null,
  created_at: '2019-11-25T21:54:48.952Z',
  created_by: {
    full_name: 'elastic',
    email: 'testemail@elastic.co',
    username: 'elastic'
  },
  severity: _case.CasePersistedSeverity.LOW,
  duration: null,
  description: 'This is a brand new case of a bad meanie defacing data',
  title: 'Super Bad Security Issue',
  status: _case.CasePersistedStatus.OPEN,
  tags: ['defacement'],
  updated_at: '2019-11-25T21:54:48.952Z',
  updated_by: {
    full_name: 'elastic',
    email: 'testemail@elastic.co',
    username: 'elastic'
  },
  connector: (0, _utils.getNoneCaseConnector)(),
  external_service: null,
  settings: {
    syncAlerts: true
  },
  owner: _constants2.SECURITY_SOLUTION_OWNER,
  assignees: [],
  total_alerts: -1,
  total_comments: -1,
  category: null
};
const basicCaseFields = exports.basicCaseFields = {
  closed_at: null,
  closed_by: null,
  created_at: '2019-11-25T21:54:48.952Z',
  created_by: {
    full_name: 'elastic',
    email: 'testemail@elastic.co',
    username: 'elastic'
  },
  severity: _domain.CaseSeverity.LOW,
  duration: null,
  description: 'This is a brand new case of a bad meanie defacing data',
  title: 'Super Bad Security Issue',
  status: _domain.CaseStatuses.open,
  tags: ['defacement'],
  updated_at: '2019-11-25T21:54:48.952Z',
  updated_by: {
    full_name: 'elastic',
    email: 'testemail@elastic.co',
    username: 'elastic'
  },
  connector: (0, _utils.getNoneCaseConnector)(),
  external_service: null,
  settings: {
    syncAlerts: true
  },
  owner: _constants2.SECURITY_SOLUTION_OWNER,
  assignees: [],
  category: null,
  customFields: [],
  observables: [],
  incremental_id: undefined
};
const createCaseSavedObjectResponse = ({
  connector,
  externalService,
  overrides,
  caseId
} = {}) => {
  var _connector$type, _connector$name, _connector$fields;
  const references = createSavedObjectReferences({
    connector,
    externalService
  });
  const formattedConnector = {
    type: (_connector$type = connector === null || connector === void 0 ? void 0 : connector.type) !== null && _connector$type !== void 0 ? _connector$type : _domain.ConnectorTypes.jira,
    name: (_connector$name = connector === null || connector === void 0 ? void 0 : connector.name) !== null && _connector$name !== void 0 ? _connector$name : _domain.ConnectorTypes.jira,
    fields: (_connector$fields = connector === null || connector === void 0 ? void 0 : connector.fields) !== null && _connector$fields !== void 0 ? _connector$fields : null
  };
  let restExternalService = null;
  if (externalService !== null) {
    const {
      connector_id: ignored,
      ...rest
    } = externalService !== null && externalService !== void 0 ? externalService : {
      connector_name: '.jira',
      external_id: '100',
      external_title: 'awesome',
      external_url: 'http://www.google.com',
      pushed_at: '2019-11-25T21:54:48.952Z',
      pushed_by: {
        full_name: 'elastic',
        email: 'testemail@elastic.co',
        username: 'elastic'
      }
    };
    restExternalService = rest;
  }
  return {
    type: _constants2.CASE_SAVED_OBJECT,
    id: caseId !== null && caseId !== void 0 ? caseId : '1',
    attributes: {
      ...basicESCaseFields,
      ...overrides,
      // if connector is null we'll default this to an incomplete jira value because the service
      // should switch it to a none connector when the id can't be found in the references array
      connector: formattedConnector,
      external_service: restExternalService
    },
    references
  };
};
exports.createCaseSavedObjectResponse = createCaseSavedObjectResponse;
const createSavedObjectReferences = ({
  connector,
  externalService
} = {}) => [...(connector && connector.id !== _constants2.NONE_CONNECTOR_ID ? [{
  id: connector.id,
  name: _constants.CONNECTOR_ID_REFERENCE_NAME,
  type: _server.ACTION_SAVED_OBJECT_TYPE
}] : []), ...(externalService && externalService.connector_id ? [{
  id: externalService.connector_id,
  name: _constants.PUSH_CONNECTOR_ID_REFERENCE_NAME,
  type: _server.ACTION_SAVED_OBJECT_TYPE
}] : [])];
exports.createSavedObjectReferences = createSavedObjectReferences;
const createConnectorObject = overrides => ({
  connector: {
    ...createJiraConnector(),
    ...overrides
  }
});
exports.createConnectorObject = createConnectorObject;
const createSOFindResponse = savedObjects => ({
  saved_objects: savedObjects,
  total: savedObjects.length,
  per_page: savedObjects.length,
  page: 1
});
exports.createSOFindResponse = createSOFindResponse;
const mockPointInTimeFinder = unsecuredSavedObjectsClient => soFindRes => {
  unsecuredSavedObjectsClient.createPointInTimeFinder.mockReturnValue({
    close: jest.fn(),
    // @ts-expect-error
    find: function* asyncGenerator() {
      yield {
        ...soFindRes
      };
    }
  });
};
exports.mockPointInTimeFinder = mockPointInTimeFinder;
const createErrorSO = type => ({
  id: '1',
  type,
  error: {
    error: 'error',
    message: 'message',
    statusCode: 500
  },
  references: []
});
exports.createErrorSO = createErrorSO;