"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSavedObjects = void 0;
var _cases = require("./cases/cases");
var _configure = require("./configure");
var _comments = require("./comments");
var _user_actions = require("./user_actions");
var _connector_mappings = require("./connector_mappings");
var _telemetry = require("./telemetry");
var _cases_rules = require("./cases_rules");
var _id_incrementer = require("./id_incrementer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSavedObjects = ({
  core,
  logger,
  persistableStateAttachmentTypeRegistry,
  lensEmbeddableFactory
}) => {
  core.savedObjects.registerType((0, _comments.createCaseCommentSavedObjectType)({
    migrationDeps: {
      persistableStateAttachmentTypeRegistry,
      lensEmbeddableFactory
    }
  }));
  core.savedObjects.registerType(_configure.caseConfigureSavedObjectType);
  core.savedObjects.registerType(_connector_mappings.caseConnectorMappingsSavedObjectType);
  core.savedObjects.registerType(_id_incrementer.caseIdIncrementerSavedObjectType);
  core.savedObjects.registerType((0, _cases.createCaseSavedObjectType)(core, logger));
  core.savedObjects.registerType((0, _user_actions.createCaseUserActionSavedObjectType)({
    persistableStateAttachmentTypeRegistry
  }));
  core.savedObjects.registerType(_telemetry.casesTelemetrySavedObjectType);
  core.savedObjects.registerType(_cases_rules.casesRulesSavedObjectType);
};
exports.registerSavedObjects = registerSavedObjects;