"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postCaseConfigureRoute = void 0;
var _api = require("../../../../common/types/api");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postCaseConfigureRoute = exports.postCaseConfigureRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.CASE_CONFIGURE_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  routerOptions: {
    access: 'public',
    summary: 'Add case settings',
    description: 'Case settings include external connection details, custom fields, and templates. Connectors are used to interface with external systems. You must create a connector before you can use it in your cases. If you set a default connector, it is automatically selected when you create cases in Kibana. If you use the create case API, however, you must still specify all of the connector details.',
    // You must have `all` privileges for the **Cases** feature in the **Management**, **Observability**, or **Security** section of the Kibana feature privileges, depending on where you are creating cases.
    tags: ['oas-tag:cases']
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const query = (0, _runtime_types.decodeWithExcessOrThrow)(_api.ConfigurationRequestRt)(request.body);
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const res = await client.configure.create(query);
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to post case configure in route: ${error}`,
        error
      });
    }
  }
});