"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patchCaseConfigureRoute = void 0;
var _api = require("../../../../common/types/api");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const patchCaseConfigureRoute = exports.patchCaseConfigureRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'patch',
  path: _constants.CASE_CONFIGURE_DETAILS_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  routerOptions: {
    access: 'public',
    summary: 'Update case settings',
    description: 'Updates case settings such as the closure type, custom fields, templates, and the default connector for cases. Connectors are used to interface with external systems. You must create a connector before you can use it in your cases.',
    // You must have `all` privileges for the **Cases** feature in the **Management**, **Observability**, or **Security** section of the Kibana feature privileges, depending on where the case was created.
    tags: ['oas-tag:cases']
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const params = (0, _runtime_types.decodeWithExcessOrThrow)(_api.CaseConfigureRequestParamsRt)(request.params);
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const configuration = request.body;
      const res = await client.configure.update(params.configuration_id, configuration);
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to patch configure in route: ${error}`,
        error
      });
    }
  }
});