"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRegisteredAttachments = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _attachments = require("../../../common/utils/attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateRegisteredAttachments = ({
  query,
  persistableStateAttachmentTypeRegistry,
  externalReferenceAttachmentTypeRegistry
}) => {
  if ((0, _attachments.isCommentRequestTypeExternalReference)(query) && !externalReferenceAttachmentTypeRegistry.has(query.externalReferenceAttachmentTypeId)) {
    throw _boom.default.badRequest(`Attachment type ${query.externalReferenceAttachmentTypeId} is not registered.`);
  }
  if ((0, _attachments.isCommentRequestTypePersistableState)(query) && !persistableStateAttachmentTypeRegistry.has(query.persistableStateAttachmentTypeId)) {
    throw _boom.default.badRequest(`Attachment type ${query.persistableStateAttachmentTypeId} is not registered.`);
  }
};
exports.validateRegisteredAttachments = validateRegisteredAttachments;