"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActivitySynchronizationSourceQuery = exports.CAI_ACTIVITY_SYNCHRONIZATION_TASK_ID = exports.CAI_ACTIVITY_SOURCE_QUERY = exports.CAI_ACTIVITY_SOURCE_INDEX = exports.CAI_ACTIVITY_INDEX_VERSION = exports.CAI_ACTIVITY_INDEX_NAME = exports.CAI_ACTIVITY_INDEX_ALIAS = exports.CAI_ACTIVITY_BACKFILL_TASK_ID = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_ACTIVITY_INDEX_NAME = exports.CAI_ACTIVITY_INDEX_NAME = '.internal.cases-activity';
const CAI_ACTIVITY_INDEX_ALIAS = exports.CAI_ACTIVITY_INDEX_ALIAS = '.cases-activity';
const CAI_ACTIVITY_INDEX_VERSION = exports.CAI_ACTIVITY_INDEX_VERSION = 1;
const CAI_ACTIVITY_SOURCE_QUERY = exports.CAI_ACTIVITY_SOURCE_QUERY = {
  bool: {
    must: [{
      term: {
        type: 'cases-user-actions'
      }
    }, {
      bool: {
        should: [{
          term: {
            'cases-user-actions.type': 'severity'
          }
        }, {
          term: {
            'cases-user-actions.type': 'delete_case'
          }
        }, {
          term: {
            'cases-user-actions.type': 'category'
          }
        }, {
          term: {
            'cases-user-actions.type': 'status'
          }
        }, {
          term: {
            'cases-user-actions.type': 'tags'
          }
        }],
        minimum_should_match: 1
      }
    }]
  }
};
const CAI_ACTIVITY_SOURCE_INDEX = exports.CAI_ACTIVITY_SOURCE_INDEX = _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX;
const CAI_ACTIVITY_BACKFILL_TASK_ID = exports.CAI_ACTIVITY_BACKFILL_TASK_ID = 'cai_activity_backfill_task';
const CAI_ACTIVITY_SYNCHRONIZATION_TASK_ID = exports.CAI_ACTIVITY_SYNCHRONIZATION_TASK_ID = 'cai_cases_activity_synchronization_task';
const getActivitySynchronizationSourceQuery = lastSyncAt => ({
  bool: {
    must: [{
      term: {
        type: 'cases-user-actions'
      }
    }, {
      range: {
        'cases-user-actions.created_at': {
          gte: lastSyncAt.toISOString()
        }
      }
    }, {
      bool: {
        should: [{
          term: {
            'cases-user-actions.type': 'severity'
          }
        }, {
          term: {
            'cases-user-actions.type': 'delete_case'
          }
        }, {
          term: {
            'cases-user-actions.type': 'category'
          }
        }, {
          term: {
            'cases-user-actions.type': 'status'
          }
        }, {
          term: {
            'cases-user-actions.type': 'tags'
          }
        }],
        minimum_should_match: 1
      }
    }]
  }
});
exports.getActivitySynchronizationSourceQuery = getActivitySynchronizationSourceQuery;