"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePersistConfiguration = void 0;
var _reactQuery = require("@kbn/react-query");
var _lodash = require("lodash");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_toast = require("../../common/use_cases_toast");
var _constants = require("../constants");
var _use_cases_context = require("../../components/cases_context/use_cases_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePersistConfiguration = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    showErrorToast,
    showSuccessToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useMutation)(({
    id,
    version,
    closureType,
    customFields,
    templates,
    connector,
    observableTypes
  }) => {
    if ((0, _lodash.isEmpty)(id) || (0, _lodash.isEmpty)(version)) {
      return (0, _api.postCaseConfigure)({
        closure_type: closureType,
        connector,
        customFields: customFields !== null && customFields !== void 0 ? customFields : [],
        templates: templates !== null && templates !== void 0 ? templates : [],
        owner: owner[0],
        observableTypes
      });
    }
    return (0, _api.patchCaseConfigure)(id, {
      version,
      closure_type: closureType,
      connector,
      customFields: customFields !== null && customFields !== void 0 ? customFields : [],
      templates: templates !== null && templates !== void 0 ? templates : [],
      observableTypes
    });
  }, {
    mutationKey: _constants.casesMutationsKeys.persistCaseConfiguration,
    onSuccess: () => {
      queryClient.invalidateQueries(_constants.casesQueriesKeys.configuration({}));
      showSuccessToast(i18n.SUCCESS_CONFIGURE);
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_TITLE
      });
    }
  });
};
exports.usePersistConfiguration = usePersistConfiguration;