"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToUserInfo = exports.convertToCaseUserWithProfileInfo = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToUserInfo = (user, userProfiles) => {
  const username = user.username;
  if (user.profileUid != null) {
    const profile = userProfiles === null || userProfiles === void 0 ? void 0 : userProfiles.get(user.profileUid);
    if (profile != null) {
      return {
        key: profile.uid,
        userInfo: profile
      };
    } else if (isValidString(username)) {
      // we couldn't find a valid profile so let's try the username
      return createWithUsername(username, user);
    } else {
      // the username wasn't valid so we'll show an unknown user
      return {
        key: user.profileUid,
        userInfo: {}
      };
    }
  } else if (isValidString(username)) {
    return createWithUsername(username, user);
  }
};
exports.convertToUserInfo = convertToUserInfo;
const isValidString = value => !(0, _lodash.isEmpty)(value);
const createWithUsername = (username, user) => {
  var _user$fullName, _user$email;
  return {
    key: username,
    userInfo: {
      user: {
        username,
        full_name: (_user$fullName = user.fullName) !== null && _user$fullName !== void 0 ? _user$fullName : undefined,
        email: (_user$email = user.email) !== null && _user$email !== void 0 ? _user$email : undefined
      }
    }
  };
};
const convertToCaseUserWithProfileInfo = user => ({
  uid: user.profileUid,
  user: {
    email: user.email,
    full_name: user.fullName,
    username: user.username
  }
});
exports.convertToCaseUserWithProfileInfo = convertToCaseUserWithProfileInfo;