"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserActionsPagination = void 0;
var _react = require("react");
var _use_infinite_find_case_user_actions = require("../../containers/use_infinite_find_case_user_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUserActionsPagination = ({
  userActivityQueryParams,
  caseId,
  lastPage
}) => {
  const {
    data: caseInfiniteUserActionsData,
    isLoading: isLoadingInfiniteUserActions,
    hasNextPage,
    fetchNextPage,
    isFetchingNextPage
  } = (0, _use_infinite_find_case_user_actions.useInfiniteFindCaseUserActions)(caseId, userActivityQueryParams, true);
  const showBottomList = lastPage > 1;
  const infiniteCaseUserActions = (0, _react.useMemo)(() => {
    var _caseInfiniteUserActi;
    if (!(caseInfiniteUserActionsData !== null && caseInfiniteUserActionsData !== void 0 && (_caseInfiniteUserActi = caseInfiniteUserActionsData.pages) !== null && _caseInfiniteUserActi !== void 0 && _caseInfiniteUserActi.length) || isLoadingInfiniteUserActions) {
      return {
        userActions: [],
        latestAttachments: []
      };
    }
    const userActionsData = [];
    const latestAttachments = [];

    // TODO: looks like it can be done in one loop
    caseInfiniteUserActionsData.pages.forEach(page => userActionsData.push(...page.userActions));
    caseInfiniteUserActionsData.pages.forEach(page => latestAttachments.push(...page.latestAttachments));
    return {
      userActions: userActionsData,
      latestAttachments
    };
  }, [caseInfiniteUserActionsData, isLoadingInfiniteUserActions]);
  return {
    lastPage,
    showBottomList,
    isLoadingInfiniteUserActions,
    infiniteCaseUserActions: infiniteCaseUserActions.userActions,
    infiniteLatestAttachments: infiniteCaseUserActions.latestAttachments,
    hasNextPage,
    fetchNextPage,
    isFetchingNextPage
  };
};
exports.useUserActionsPagination = useUserActionsPagination;