"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_MIME_TYPE = exports.TYPE = exports.TEXT_MIME_TYPE = exports.SUCCESSFUL_UPLOAD_FILE_NAME = exports.SHOWING_FILES = exports.SEARCH_PLACEHOLDER = exports.RESULTS_COUNT = exports.REMOVED_FILE = exports.PDF_MIME_TYPE = exports.NO_PREVIEW = exports.NO_FILES = exports.NAME = exports.IMAGE_MIME_TYPE = exports.FILES_TABLE = exports.FAILED_UPLOAD = exports.DOWNLOAD_FILE = exports.DELETE_FILE_TITLE = exports.DELETE_FILE = exports.DELETE = exports.DATE_ADDED = exports.COPY_FILE_HASH_SUCCESS = exports.COPY_FILE_HASH = exports.COMPRESSED_MIME_TYPE = exports.CLOSE_MODAL = exports.ADD_FILE = exports.ADDED_UNKNOWN_FILE = exports.ADDED = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTIONS = exports.ACTIONS = _i18n.i18n.translate('xpack.cases.caseView.files.actions', {
  defaultMessage: 'Actions'
});
const ADD_FILE = exports.ADD_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.addFile', {
  defaultMessage: 'Add file'
});
const CLOSE_MODAL = exports.CLOSE_MODAL = _i18n.i18n.translate('xpack.cases.caseView.files.closeModal', {
  defaultMessage: 'Close'
});
const DATE_ADDED = exports.DATE_ADDED = _i18n.i18n.translate('xpack.cases.caseView.files.dateAdded', {
  defaultMessage: 'Date added'
});
const DELETE_FILE = exports.DELETE_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.deleteFile', {
  defaultMessage: 'Delete file'
});
const DOWNLOAD_FILE = exports.DOWNLOAD_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.downloadFile', {
  defaultMessage: 'Download file'
});
const COPY_FILE_HASH = exports.COPY_FILE_HASH = _i18n.i18n.translate('xpack.cases.caseView.files.copyFileHash', {
  defaultMessage: 'Copy file hash'
});
const COPY_FILE_HASH_SUCCESS = hashName => _i18n.i18n.translate('xpack.cases.caseView.files.copyFileHashSuccess', {
  values: {
    hashName
  },
  defaultMessage: `Copied {hashName} file hash successfully`
});
exports.COPY_FILE_HASH_SUCCESS = COPY_FILE_HASH_SUCCESS;
const FILES_TABLE = exports.FILES_TABLE = _i18n.i18n.translate('xpack.cases.caseView.files.filesTable', {
  defaultMessage: 'Files table'
});
const NAME = exports.NAME = _i18n.i18n.translate('xpack.cases.caseView.files.name', {
  defaultMessage: 'Name'
});
const NO_FILES = exports.NO_FILES = _i18n.i18n.translate('xpack.cases.caseView.files.noFilesAvailable', {
  defaultMessage: 'No files available'
});
const NO_PREVIEW = exports.NO_PREVIEW = _i18n.i18n.translate('xpack.cases.caseView.files.noPreviewAvailable', {
  defaultMessage: 'No preview available'
});
const RESULTS_COUNT = exports.RESULTS_COUNT = _i18n.i18n.translate('xpack.cases.caseView.files.resultsCount', {
  defaultMessage: 'Showing'
});
const TYPE = exports.TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.type', {
  defaultMessage: 'Type'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseView.files.searchPlaceholder', {
  defaultMessage: 'Search files'
});
const FAILED_UPLOAD = exports.FAILED_UPLOAD = _i18n.i18n.translate('xpack.cases.caseView.files.failedUpload', {
  defaultMessage: 'Failed to upload file'
});
const UNKNOWN_MIME_TYPE = exports.UNKNOWN_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.unknownMimeType', {
  defaultMessage: 'Unknown'
});
const IMAGE_MIME_TYPE = exports.IMAGE_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.imageMimeType', {
  defaultMessage: 'Image'
});
const TEXT_MIME_TYPE = exports.TEXT_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.textMimeType', {
  defaultMessage: 'Text'
});
const COMPRESSED_MIME_TYPE = exports.COMPRESSED_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.compressedMimeType', {
  defaultMessage: 'Compressed'
});
const PDF_MIME_TYPE = exports.PDF_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.pdfMimeType', {
  defaultMessage: 'PDF'
});
const SUCCESSFUL_UPLOAD_FILE_NAME = fileName => _i18n.i18n.translate('xpack.cases.caseView.files.successfulUploadFileName', {
  defaultMessage: 'File {fileName} uploaded successfully',
  values: {
    fileName
  }
});
exports.SUCCESSFUL_UPLOAD_FILE_NAME = SUCCESSFUL_UPLOAD_FILE_NAME;
const SHOWING_FILES = totalFiles => _i18n.i18n.translate('xpack.cases.caseView.files.showingFilesTitle', {
  values: {
    totalFiles
  },
  defaultMessage: 'Showing {totalFiles} {totalFiles, plural, =1 {file} other {files}}'
});
exports.SHOWING_FILES = SHOWING_FILES;
const ADDED = exports.ADDED = _i18n.i18n.translate('xpack.cases.caseView.files.added', {
  defaultMessage: 'added '
});
const ADDED_UNKNOWN_FILE = exports.ADDED_UNKNOWN_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.addedUnknownFile', {
  defaultMessage: 'added an unknown file'
});
const DELETE = exports.DELETE = _i18n.i18n.translate('xpack.cases.caseView.files.delete', {
  defaultMessage: 'Delete'
});
const DELETE_FILE_TITLE = exports.DELETE_FILE_TITLE = _i18n.i18n.translate('xpack.cases.caseView.files.deleteThisFile', {
  defaultMessage: 'Delete this file?'
});
const REMOVED_FILE = exports.REMOVED_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.removedFile', {
  defaultMessage: 'removed file'
});