"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setThirdPartyToMapping = exports.setActionTypeToMapping = exports.normalizeCaseConnector = exports.normalizeActionConnector = exports.getNoneConnector = void 0;
var _domain = require("../../../common/types/domain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setActionTypeToMapping = (caseField, newActionType, mapping) => {
  const findItemIndex = mapping.findIndex(item => item.source === caseField);
  if (findItemIndex >= 0) {
    return [...mapping.slice(0, findItemIndex), {
      ...mapping[findItemIndex],
      actionType: newActionType
    }, ...mapping.slice(findItemIndex + 1)];
  }
  return [...mapping];
};
exports.setActionTypeToMapping = setActionTypeToMapping;
const setThirdPartyToMapping = (caseField, newThirdPartyField, mapping) => mapping.map(item => {
  if (item.source !== caseField && item.target === newThirdPartyField) {
    return {
      ...item,
      target: 'not_mapped'
    };
  } else if (item.source === caseField) {
    return {
      ...item,
      target: newThirdPartyField
    };
  }
  return item;
});
exports.setThirdPartyToMapping = setThirdPartyToMapping;
const getNoneConnector = () => ({
  id: 'none',
  name: 'none',
  type: _domain.ConnectorTypes.none,
  fields: null
});
exports.getNoneConnector = getNoneConnector;
const normalizeActionConnector = (actionConnector, fields = null) => {
  const caseConnectorFieldsType = {
    type: actionConnector.actionTypeId,
    fields
  };
  return {
    id: actionConnector.id,
    name: actionConnector.name,
    ...caseConnectorFieldsType
  };
};
exports.normalizeActionConnector = normalizeActionConnector;
const normalizeCaseConnector = (connectors, caseConnector) => {
  var _connectors$find;
  return (_connectors$find = connectors.find(c => c.id === caseConnector.id)) !== null && _connectors$find !== void 0 ? _connectors$find : null;
};
exports.normalizeCaseConnector = normalizeCaseConnector;