"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Connectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _connectors_dropdown = require("./connectors_dropdown");
var i18n = _interopRequireWildcard(require("./translations"));
var _mapping = require("./mapping");
var _domain = require("../../../common/types/domain");
var _deprecated_callout = require("../connectors/deprecated_callout");
var _utils = require("../utils");
var _kibana = require("../../common/lib/kibana");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorsComponent = ({
  actionTypes,
  connectors,
  disabled,
  handleShowEditFlyout,
  isLoading,
  mappings,
  onChangeConnector,
  selectedConnector,
  updateConnectorDisabled,
  onAddNewConnector
}) => {
  var _connector$name;
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const canSave = actions.crud;
  const connector = (0, _react.useMemo)(() => connectors.find(c => c.id === selectedConnector.id), [connectors, selectedConnector.id]);
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const canUseConnectors = permissions.connectors && actions.read;
  const connectorsName = (_connector$name = connector === null || connector === void 0 ? void 0 : connector.name) !== null && _connector$name !== void 0 ? _connector$name : 'none';
  const actionTypeName = (0, _react.useMemo)(() => {
    var _actionTypes$find$nam, _actionTypes$find;
    return (_actionTypes$find$nam = (_actionTypes$find = actionTypes.find(c => c.id === selectedConnector.type)) === null || _actionTypes$find === void 0 ? void 0 : _actionTypes$find.name) !== null && _actionTypes$find$nam !== void 0 ? _actionTypes$find$nam : i18n.UNKNOWN;
  }, [actionTypes, selectedConnector.type]);
  const dropDownLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, i18n.INCIDENT_MANAGEMENT_SYSTEM_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, connectorsName !== 'none' && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    disabled: updateConnectorDisabled,
    onClick: handleShowEditFlyout,
    "data-test-subj": "case-configure-update-selected-connector-button"
  }, i18n.UPDATE_SELECTED_CONNECTOR(connectorsName)))), [connectorsName, handleShowEditFlyout, updateConnectorDisabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.INCIDENT_MANAGEMENT_SYSTEM_TITLE),
    description: i18n.INCIDENT_MANAGEMENT_SYSTEM_DESC,
    "data-test-subj": "case-connectors-form-group"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: dropDownLabel,
    "data-test-subj": "case-connectors-form-row",
    labelAppend: canSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": "add-new-connector",
      onClick: onAddNewConnector
    }, i18n.ADD_CONNECTOR) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, canUseConnectors ? /*#__PURE__*/_react.default.createElement(_connectors_dropdown.ConnectorsDropdown, {
    connectors: connectors,
    disabled: disabled,
    selectedConnector: selectedConnector.id,
    isLoading: isLoading,
    onChange: onChangeConnector
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "configure-case-connector-permissions-error-msg",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.READ_ACTIONS_PERMISSIONS_ERROR_MSG))), selectedConnector.type !== _domain.ConnectorTypes.none && (0, _utils.isDeprecatedConnector)(connector) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, null)), selectedConnector.type !== _domain.ConnectorTypes.none ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_mapping.Mapping, {
    actionTypeName: actionTypeName,
    connectorType: selectedConnector.type,
    isLoading: isLoading,
    mappings: mappings
  })) : null))));
};
ConnectorsComponent.displayName = 'Connectors';
const Connectors = exports.Connectors = /*#__PURE__*/_react.default.memo(ConnectorsComponent);