"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesContext = void 0;
var _react = require("react");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesContext = () => {
  const casesContext = (0, _react.useContext)(_.CasesContext);
  if (!casesContext) {
    throw new Error('useCasesContext must be used within a CasesProvider and have a defined value. See https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/cases/README.md#cases-ui');
  }
  return casesContext;
};
exports.useCasesContext = useCasesContext;