"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsLoadingCases = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../containers/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true or false if any of the queries and mutations
 * are fetching in the all cases page
 */

const useIsLoadingCases = () => {
  const isDeletingCases = (0, _reactQuery.useIsMutating)(_constants.casesMutationsKeys.deleteCases);
  const isUpdatingCases = (0, _reactQuery.useIsMutating)(_constants.casesMutationsKeys.updateCases);
  return Boolean(isDeletingCases) || Boolean(isUpdatingCases);
};
exports.useIsLoadingCases = useIsLoadingCases;