"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConnectorsToMockActionRegistry = void 0;
var _action_type_registry = require("@kbn/triggers-actions-ui-plugin/public/application/action_type_registry.mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUniqueActionTypeIds = connectors => new Set(connectors.map(connector => connector.actionTypeId));
const registerConnectorsToMockActionRegistry = (actionTypeRegistry, connectors) => {
  const {
    createMockActionTypeModel
  } = _action_type_registry.actionTypeRegistryMock;
  const uniqueActionTypeIds = getUniqueActionTypeIds(connectors);
  uniqueActionTypeIds.forEach(actionTypeId => actionTypeRegistry.register(createMockActionTypeModel({
    id: actionTypeId,
    iconClass: 'logoSecurity'
  })));
};
exports.registerConnectorsToMockActionRegistry = registerConnectorsToMockActionRegistry;