"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStartTransaction = void 0;
var _react = require("react");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TRANSACTION_OPTIONS = {
  managed: true
};
const DEFAULT_TRANSACTION_TYPE = 'user-interaction';
const useStartTransaction = () => {
  const {
    apm
  } = (0, _kibana.useKibana)().services;
  const startTransaction = (0, _react.useCallback)((name, {
    type = DEFAULT_TRANSACTION_TYPE,
    options = DEFAULT_TRANSACTION_OPTIONS
  } = {}) => apm === null || apm === void 0 ? void 0 : apm.startTransaction(name, type, options), [apm]);
  return {
    startTransaction
  };
};
exports.useStartTransaction = useStartTransaction;