"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createClientAPI = void 0;
var _api = require("../../../common/api");
var _api2 = require("../../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createClientAPI = ({
  http
}) => {
  return {
    getRelatedCases: async (alertId, query) => http.get((0, _api.getCasesFromAlertsUrl)(alertId), {
      query
    }),
    cases: {
      find: (query, signal) => (0, _api2.getCases)({
        http,
        query,
        signal
      }),
      getCasesMetrics: (query, signal) => (0, _api2.getCasesMetrics)({
        http,
        signal,
        query
      }),
      bulkGet: (params, signal) => (0, _api2.bulkGetCases)({
        http,
        signal,
        params
      })
    }
  };
};
exports.createClientAPI = createClientAPI;