"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleCaseMetricsResponseRt = exports.SingleCaseMetricsRequestRt = exports.SingleCaseMetricsFeatureFieldRt = exports.CasesMetricsResponseRt = exports.CasesMetricsRequestRt = exports.CasesMetricsFeatureFieldRt = exports.CaseMetricsFeature = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let CaseMetricsFeature = exports.CaseMetricsFeature = /*#__PURE__*/function (CaseMetricsFeature) {
  CaseMetricsFeature["ALERTS_COUNT"] = "alerts.count";
  CaseMetricsFeature["ALERTS_USERS"] = "alerts.users";
  CaseMetricsFeature["ALERTS_HOSTS"] = "alerts.hosts";
  CaseMetricsFeature["ACTIONS_ISOLATE_HOST"] = "actions.isolateHost";
  CaseMetricsFeature["CONNECTORS"] = "connectors";
  CaseMetricsFeature["LIFESPAN"] = "lifespan";
  CaseMetricsFeature["MTTR"] = "mttr";
  CaseMetricsFeature["STATUS"] = "status";
  return CaseMetricsFeature;
}({});
const SingleCaseMetricsFeatureFieldRt = exports.SingleCaseMetricsFeatureFieldRt = rt.union([rt.literal(CaseMetricsFeature.ALERTS_COUNT), rt.literal(CaseMetricsFeature.ALERTS_USERS), rt.literal(CaseMetricsFeature.ALERTS_HOSTS), rt.literal(CaseMetricsFeature.ACTIONS_ISOLATE_HOST), rt.literal(CaseMetricsFeature.CONNECTORS), rt.literal(CaseMetricsFeature.LIFESPAN)]);
const CasesMetricsFeatureFieldRt = exports.CasesMetricsFeatureFieldRt = rt.union([SingleCaseMetricsFeatureFieldRt, rt.literal(CaseMetricsFeature.MTTR), rt.literal(CaseMetricsFeature.STATUS)]);
const StatusInfoRt = rt.strict({
  /**
   * Duration the case was in the open status in milliseconds
   */
  openDuration: rt.number,
  /**
   * Duration the case was in the in-progress status in milliseconds. Zero indicates the case was never in-progress.
   */
  inProgressDuration: rt.number,
  /**
   * The ISO string representation of the dates the case was reopened
   */
  reopenDates: rt.array(rt.string)
});
const AlertHostsMetricsRt = rt.strict({
  /**
   * Total unique hosts represented in the alerts
   */
  total: rt.number,
  values: rt.array(rt.strict({
    /**
     * Host name
     */
    name: rt.union([rt.string, rt.undefined]),
    /**
     * Unique identifier for the host
     */
    id: rt.string,
    /**
     * Number of alerts that have this particular host name
     */
    count: rt.number
  }))
});
const AlertUsersMetricsRt = rt.strict({
  /**
   * Total unique users represented in the alerts
   */
  total: rt.number,
  values: rt.array(rt.strict({
    /**
     * Username
     */
    name: rt.string,
    /**
     * Number of alerts that have this particular username
     */
    count: rt.number
  }))
});
const SingleCaseMetricsRequestRt = exports.SingleCaseMetricsRequestRt = rt.strict({
  /**
   * The metrics to retrieve.
   */
  features: rt.array(SingleCaseMetricsFeatureFieldRt)
});
const CasesMetricsRequestRt = exports.CasesMetricsRequestRt = rt.intersection([rt.strict({
  /**
   * The metrics to retrieve.
   */
  features: rt.array(CasesMetricsFeatureFieldRt)
}), rt.exact(rt.partial({
  /**
   * A KQL date. If used all cases created after (gte) the from date will be returned
   */
  from: rt.string,
  /**
   * A KQL date. If used all cases created before (lte) the to date will be returned.
   */
  to: rt.string,
  /**
   * The owner(s) to filter by. The user making the request must have privileges to retrieve cases of that
   * ownership or they will be ignored. If no owner is included, then all ownership types will be included in the response
   * that the user has access to.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}))]);
const SingleCaseMetricsResponseRt = exports.SingleCaseMetricsResponseRt = rt.exact(rt.partial({
  alerts: rt.exact(rt.partial({
    /**
     * Number of alerts attached to the case
     */
    count: rt.number,
    /**
     * Host information represented from the alerts attached to this case
     */
    hosts: AlertHostsMetricsRt,
    /**
     * User information represented from the alerts attached to this case
     */
    users: AlertUsersMetricsRt
  })),
  /**
   * External connectors associated with the case
   */
  connectors: rt.strict({
    /**
     * Total number of connectors in the case
     */
    total: rt.number
  }),
  /**
   * Actions taken within the case
   */
  actions: rt.exact(rt.partial({
    isolateHost: rt.strict({
      /**
       * Isolate host action information
       */
      isolate: rt.strict({
        /**
         * Total times the isolate host action has been performed
         */
        total: rt.number
      }),
      /**
       * Unisolate host action information
       */
      unisolate: rt.strict({
        /**
         * Total times the unisolate host action has been performed
         */
        total: rt.number
      })
    })
  })),
  /**
   * The case's open,close,in-progress details
   */
  lifespan: rt.strict({
    /**
     * Date the case was created, in ISO format
     */
    creationDate: rt.string,
    /**
     * Date the case was closed, in ISO format. Will be null if the case is not currently closed
     */
    closeDate: rt.union([rt.string, rt.null]),
    /**
     * The case's status information regarding durations in a specific status
     */
    statusInfo: StatusInfoRt
  })
}));
const CasesMetricsResponseRt = exports.CasesMetricsResponseRt = rt.exact(rt.partial({
  /**
   * The average resolve time of all cases in seconds
   */
  mttr: rt.union([rt.number, rt.null]),
  /**
   * The number of total cases per status
   */
  status: rt.strict({
    open: rt.number,
    inProgress: rt.number,
    closed: rt.number
  })
}));