"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloneStore = cloneStore;
exports.createStore = createStore;
exports.destroyStore = destroyStore;
exports.getState = getState;
exports.getStore = getStore;
var _redux = require("redux");
var _lodash = require("lodash");
var _middleware = require("./middleware");
var _reducers = require("./reducers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let store;
function getStore() {
  return store;
}
function cloneStore() {
  const state = store.getState();
  store = undefined;
  return createStore(state);
}
function createStore(initialState) {
  if (typeof store !== 'undefined') {
    throw new Error('Redux store can only be initialized once');
  }
  if (!(0, _lodash.isPlainObject)(initialState)) {
    throw new Error('Initial state must be a plain object');
  }
  const rootReducer = (0, _reducers.getRootReducer)(initialState);
  store = (0, _redux.createStore)(rootReducer, initialState, _middleware.middleware);
  return store;
}
function destroyStore() {
  if (store) {
    // Replace reducer so that anything that gets fired after navigating away doesn't really do anything
    store.replaceReducer(state => state);
  }
  store = undefined;
}
function getState() {
  return store.getState();
}