"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transientReducer = void 0;
var _reduxActions = require("redux-actions");
var _objectPathImmutable = require("object-path-immutable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transientReducer = exports.transientReducer = (0, _reduxActions.handleActions)({
  // clear all the resolved args when restoring the history
  // TODO: we shouldn't need to reset the resolved args for history
  ['restoreHistory']: transientState => (0, _objectPathImmutable.set)(transientState, 'resolvedArgs', {}),
  ['removeElements']: (transientState, {
    payload: {
      elementIds
    }
  }) => {
    const {
      selectedToplevelNodes
    } = transientState;
    return (0, _objectPathImmutable.del)({
      ...transientState,
      selectedToplevelNodes: selectedToplevelNodes.filter(n => elementIds.indexOf(n) < 0)
    }, ['resolvedArgs', elementIds]);
  },
  ['setFirstLoad']: (transientState, {
    payload
  }) => {
    return (0, _objectPathImmutable.set)(transientState, 'isFirstLoad', Boolean(payload));
  },
  ['setFullscreen']: (transientState, {
    payload
  }) => {
    return (0, _objectPathImmutable.set)(transientState, 'fullscreen', Boolean(payload));
  },
  ['setElementStats']: (transientState, {
    payload
  }) => {
    return (0, _objectPathImmutable.set)(transientState, 'elementStats', payload);
  },
  ['selectToplevelNodes']: (transientState, {
    payload
  }) => {
    return {
      ...transientState,
      selectedToplevelNodes: payload
    };
  },
  ['setZoomScale']: (transientState, {
    payload
  }) => {
    return {
      ...transientState,
      zoomScale: payload || 1
    };
  },
  ['setPage']: transientState => {
    return {
      ...transientState,
      selectedToplevelNodes: []
    };
  },
  ['addPage']: transientState => {
    return {
      ...transientState,
      selectedToplevelNodes: []
    };
  },
  ['duplicatePage']: transientState => {
    return {
      ...transientState,
      selectedToplevelNodes: []
    };
  },
  ['setRefreshInterval']: (transientState, {
    payload
  }) => {
    return {
      ...transientState,
      refresh: {
        interval: Number(payload) || 0
      }
    };
  },
  ['enableAutoplay']: (transientState, {
    payload
  }) => {
    return (0, _objectPathImmutable.set)(transientState, 'autoplay.enabled', Boolean(payload) || false);
  },
  ['setAutoplayInterval']: (transientState, {
    payload
  }) => {
    return (0, _objectPathImmutable.set)(transientState, 'autoplay.interval', Number(payload) || 0);
  }
}, {});