"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkpad = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _workpad = require("../../../state/selectors/workpad");
var _workpad2 = require("../../../state/actions/workpad");
var _assets = require("../../../state/actions/assets");
var _transient = require("../../../state/actions/transient");
var _canvas_workpad_service = require("../../../services/canvas_workpad_service");
var _kibana_services = require("../../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

// @ts-expect-error

const getWorkpadLabel = () => _i18n.i18n.translate('xpack.canvas.workpadResolve.redirectLabel', {
  defaultMessage: 'Workpad'
});
const useWorkpad = (workpadId, loadPages = true, getRedirectPath) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const storedWorkpad = (0, _reactRedux.useSelector)(_workpad.getWorkpad);
  const [error, setError] = (0, _react.useState)(undefined);
  const [resolveInfo, setResolveInfo] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        const {
          workpad: {
            assets,
            ...workpad
          },
          ...resolveProps
        } = await (0, _canvas_workpad_service.getCanvasWorkpadService)().resolve(workpadId);
        setResolveInfo({
          id: workpadId,
          ...resolveProps
        });

        // If it's an alias match, we know we are going to redirect so don't even dispatch that we got the workpad
        if (storedWorkpad.id !== workpadId && resolveProps.outcome !== 'aliasMatch') {
          workpad.aliasId = resolveProps.aliasId;
          dispatch((0, _assets.setAssets)(assets));
          dispatch((0, _workpad2.setWorkpad)(workpad, {
            loadPages
          }));
          dispatch((0, _transient.setZoomScale)(1));
        }
      } catch (e) {
        setError(e);
      }
    })();
  }, [workpadId, dispatch, setError, loadPages, storedWorkpad.id]);
  (0, _react.useEffect)(() => {
    // If the resolved info is not for the current workpad id, bail out
    if (resolveInfo && resolveInfo.id !== workpadId) {
      return;
    }
    (async () => {
      if (!resolveInfo) return;
      const {
        aliasId,
        outcome,
        aliasPurpose
      } = resolveInfo;
      if (outcome === 'aliasMatch' && _kibana_services.spacesService && aliasId) {
        const redirectPath = getRedirectPath(aliasId);
        await _kibana_services.spacesService.ui.redirectLegacyUrl({
          path: `#${redirectPath}`,
          aliasPurpose,
          objectNoun: getWorkpadLabel()
        });
      }
    })();
  }, [workpadId, resolveInfo, getRedirectPath]);
  return [storedWorkpad.id === workpadId ? storedWorkpad : undefined, error];
};
exports.useWorkpad = useWorkpad;