"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getError = getError;
exports.getState = getState;
exports.getValue = getValue;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getState(resolvedArg) {
  return (0, _lodash.get)(resolvedArg, 'state', null);
}
function getValue(resolvedArg) {
  return (0, _lodash.get)(resolvedArg, 'value', null);
}
function getError(resolvedArg) {
  if (getState(resolvedArg) !== 'error') {
    return null;
  }
  return (0, _lodash.get)(resolvedArg, 'error', null);
}