"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStore = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let counter = 0;
const createStore = (initialState, updater) => {
  let currentState = initialState;
  const commit = (type, payload) => {
    return currentState = updater({
      ...currentState,
      primaryUpdate: {
        type,
        payload: {
          ...payload,
          uid: counter++
        }
      }
    });
  };
  const getCurrentState = () => currentState;
  const setCurrentState = state => {
    currentState = state;
    commit('flush', {});
  };
  return {
    getCurrentState,
    setCurrentState,
    commit
  };
};
exports.createStore = createStore;