"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wheel = void 0;
var _shape_factory = require("../shape_factory");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wheel = exports.Wheel = (0, _shape_factory.createShape)({
  viewBox: {
    minX: 0,
    minY: 0,
    width: 120,
    height: 120
  },
  shapeType: _types.SvgElementTypes.path,
  shapeProps: {
    d: 'M 60 0 A 60 60 0 1 1 60 120 A 60 60 0 1 1 60 0 Z'
  },
  textAttributes: {
    x: '60',
    y: '60',
    textAnchor: 'middle',
    dominantBaseline: 'central'
  }
});