"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProgressShape = void 0;
var _gauge = require("./gauge");
var _horizontal_bar = require("./horizontal_bar");
var _horizontal_pill = require("./horizontal_pill");
var _semicircle = require("./semicircle");
var _unicorn = require("./unicorn");
var _vertical_bar = require("./vertical_bar");
var _vertical_pill = require("./vertical_pill");
var _wheel = require("./wheel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shapes = {
  gauge: _gauge.Gauge,
  horizontalBar: _horizontal_bar.HorizontalBar,
  horizontalPill: _horizontal_pill.HorizontalPill,
  semicircle: _semicircle.Semicircle,
  unicorn: _unicorn.Unicorn,
  verticalBar: _vertical_bar.VerticalBar,
  verticalPill: _vertical_pill.VerticalPill,
  wheel: _wheel.Wheel
};
const getProgressShape = shapeType => shapes[shapeType];
exports.getProgressShape = getProgressShape;