"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareColorPalette = exports.findPalette = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findPalette = (colorPalette, colorPalettes = []) => {
  var _colorPalettes$filter;
  const palette = (_colorPalettes$filter = colorPalettes.filter(cp => cp.id === (colorPalette === null || colorPalette === void 0 ? void 0 : colorPalette.id))[0]) !== null && _colorPalettes$filter !== void 0 ? _colorPalettes$filter : null;
  if (palette === null) {
    var _colorPalettes$filter2;
    return (_colorPalettes$filter2 = colorPalettes.filter(cp => (0, _lodash.isEqual)(cp.colors, colorPalette === null || colorPalette === void 0 ? void 0 : colorPalette.colors))[0]) !== null && _colorPalettes$filter2 !== void 0 ? _colorPalettes$filter2 : null;
  }
  return palette;
};
exports.findPalette = findPalette;
const prepareColorPalette = ({
  id,
  label,
  gradient,
  colors
}) => ({
  value: id,
  title: label,
  type: gradient ? 'gradient' : 'fixed',
  palette: colors
});
exports.prepareColorPalette = prepareColorPalette;