"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Datatable = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _paginate = require("../paginate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIcon = type => {
  if (type === null) {
    return;
  }
  let icon;
  switch (type) {
    case 'string':
      icon = 'string';
      break;
    case 'number':
      icon = 'number';
      break;
    case 'date':
      icon = 'calendar';
      break;
    case 'boolean':
      icon = 'invert';
      break;
    default:
      icon = 'question';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    color: "subdued"
  });
};
const getColumnName = col => typeof col === 'string' ? col : col.name;
const getColumnId = col => typeof col === 'string' ? col : col.id;
const getColumnType = col => {
  var _col$meta;
  return ((_col$meta = col.meta) === null || _col$meta === void 0 ? void 0 : _col$meta.type) || null;
};
const getFormattedValue = (val, type) => {
  if (type === 'date') {
    return (0, _moment.default)(val).format();
  }
  return String(val);
};
const Datatable = ({
  datatable,
  paginate = false,
  perPage = 10,
  showHeader = false
}) => /*#__PURE__*/_react.default.createElement(_paginate.Paginate, {
  rows: datatable.rows,
  perPage: perPage
}, ({
  rows,
  setPage,
  pageNumber,
  totalPages
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataTable"
}, /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataTable__tableWrapper"
}, /*#__PURE__*/_react.default.createElement("table", {
  className: "canvasDataTable__table"
}, !showHeader ? null : /*#__PURE__*/_react.default.createElement("thead", {
  className: "canvasDataTable__thead"
}, /*#__PURE__*/_react.default.createElement("tr", {
  className: "canvasDataTable__tr"
}, datatable.columns.map(col => /*#__PURE__*/_react.default.createElement("th", {
  key: `header-${getColumnName(col)}`,
  className: "canvasDataTable__th"
}, getColumnName(col), "\xA0", getIcon(getColumnType(col)))))), /*#__PURE__*/_react.default.createElement("tbody", {
  className: "canvasDataTable__tbody"
}, rows.map((row, i) => /*#__PURE__*/_react.default.createElement("tr", {
  key: i,
  className: "canvasDataTable__tr"
}, datatable.columns.map(col => /*#__PURE__*/_react.default.createElement("td", {
  key: `row-${i}-${getColumnName(col)}`,
  className: "canvasDataTable__td"
}, getFormattedValue(row[getColumnId(col)], getColumnType(col))))))))), paginate && /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataTable__footer"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
  pageCount: totalPages,
  activePage: pageNumber,
  onPageClick: setPage
}))));
exports.Datatable = Datatable;
Datatable.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  datatable: _propTypes.default.object.isRequired,
  paginate: _propTypes.default.bool,
  perPage: _propTypes.default.number,
  showHeader: _propTypes.default.bool
};