"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDatasource = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getPanelDescription: () => _i18n.i18n.translate('xpack.canvas.datasourceNoDatasource.panelDescription', {
    defaultMessage: "This element does not have an attached data source. This is usually because the element is an image or other static asset. If that's not the case you might want to check your expression to make sure it is not malformed."
  }),
  getPanelTitle: () => _i18n.i18n.translate('xpack.canvas.datasourceNoDatasource.panelTitle', {
    defaultMessage: 'No data source present'
  })
};
const NoDatasource = () => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataSource__section"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: strings.getPanelTitle(),
  iconType: "info"
}, /*#__PURE__*/_react.default.createElement("p", null, strings.getPanelDescription())));
exports.NoDatasource = NoDatasource;
NoDatasource.propTypes = {
  done: _propTypes.default.func
};