"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleFailure = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _tooltip_icon = require("../tooltip_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getFailureTooltip: () => _i18n.i18n.translate('xpack.canvas.argFormSimpleFailure.failureTooltip', {
    defaultMessage: 'The interface for this argument could not parse the value, so a fallback input is being used'
  })
};

// This is what is being generated by render() from the Arg class. It is called in FunctionForm
const SimpleFailure = () => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasArg--error canvasArg--error-simple"
}, /*#__PURE__*/_react.default.createElement(_tooltip_icon.TooltipIcon, {
  position: "left",
  icon: _tooltip_icon.IconType.warning,
  content: strings.getFailureTooltip()
}));
exports.SimpleFailure = SimpleFailure;