"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNCT = getNCT;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _document_type = require("../../../common/document_type");
var _rollup = require("../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getNCT({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  size
}) {
  return await apmEventClient.search('get_mobile_nct', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.SpanEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
        }
      },
      aggs: {
        netConnectionTypes: {
          terms: {
            field: _apm.NETWORK_CONNECTION_TYPE,
            size
          }
        }
      }
    }
  });
}