"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileLocationStatsPeriods = getMobileLocationStatsPeriods;
var _apm = require("../../../common/es_fields/apm");
var _get_mobile_sessions_by_location = require("./get_mobile_sessions_by_location");
var _get_mobile_http_requests_by_location = require("./get_mobile_http_requests_by_location");
var _get_mobile_crashes_by_location = require("./get_mobile_crashes_by_location");
var _get_mobile_launches_by_location = require("./get_mobile_launches_by_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMobileLocationStats({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  locationField = _apm.CLIENT_GEO_COUNTRY_NAME,
  offset
}) {
  const commonProps = {
    kuery,
    apmEventClient,
    serviceName,
    environment,
    start,
    end,
    locationField,
    offset
  };
  const [mostSessions, mostRequests, mostCrashes, mostLaunches] = await Promise.all([(0, _get_mobile_sessions_by_location.getSessionsByLocation)({
    ...commonProps
  }), (0, _get_mobile_http_requests_by_location.getHttpRequestsByLocation)({
    ...commonProps
  }), (0, _get_mobile_crashes_by_location.getCrashesByLocation)({
    ...commonProps
  }), (0, _get_mobile_launches_by_location.getLaunchesByLocation)({
    ...commonProps
  })]);
  return {
    mostSessions,
    mostRequests,
    mostCrashes,
    mostLaunches
  };
}
async function getMobileLocationStatsPeriods({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  locationField,
  offset
}) {
  const commonProps = {
    kuery,
    apmEventClient,
    serviceName,
    environment,
    locationField
  };
  const currentPeriodPromise = getMobileLocationStats({
    ...commonProps,
    start,
    end
  });
  const previousPeriodPromise = offset ? getMobileLocationStats({
    ...commonProps,
    start,
    end,
    offset
  }) : {
    mostSessions: {
      value: null,
      timeseries: []
    },
    mostRequests: {
      value: null,
      timeseries: []
    },
    mostCrashes: {
      value: null,
      timeseries: []
    },
    mostLaunches: {
      value: null,
      timeseries: []
    }
  };
  const [currentPeriod, previousPeriod] = await Promise.all([currentPeriodPromise, previousPeriodPromise]);
  return {
    currentPeriod,
    previousPeriod
  };
}