"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_metrics_chart_data_by_agent = require("./get_metrics_chart_data_by_agent");
var _get_service_nodes = require("./get_service_nodes");
var _route = require("./serverless/route");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/metrics/charts',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      agentName: t.string
    }), t.partial({
      serviceNodeName: t.string
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params,
      config
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      serviceName
    } = params.path;
    const {
      agentName,
      environment,
      kuery,
      serviceNodeName,
      start,
      end
    } = params.query;
    const charts = await (0, _get_metrics_chart_data_by_agent.getMetricsChartDataByAgent)({
      environment,
      kuery,
      config,
      apmEventClient,
      serviceName,
      agentName,
      serviceNodeName,
      start,
      end
    });
    return {
      charts
    };
  }
});
const serviceMetricsJvm = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/metrics/nodes',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end
    } = params.query;
    const serviceNodes = await (0, _get_service_nodes.getServiceNodes)({
      kuery,
      apmEventClient,
      serviceName,
      environment,
      start,
      end
    });
    return {
      serviceNodes
    };
  }
});
const metricsRouteRepository = exports.metricsRouteRepository = {
  ...metricsChartsRoute,
  ...serviceMetricsJvm,
  ..._route.metricsServerlessRouteRepository
};