"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLegacyUrlParams = useLegacyUrlParams;
var _lodash = require("lodash");
var _react = require("react");
var _url_params_context = require("./url_params_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLegacyUrlParams() {
  const context = (0, _react.useContext)(_url_params_context.UrlParamsContext);
  return (0, _react.useMemo)(() => {
    return {
      ...context,
      urlParams: (0, _lodash.omit)(context.urlParams, ['environment', 'kuery'])
    };
  }, [context]);
}