"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnnotationsContext = useAnnotationsContext;
var _react = require("react");
var _annotations_context = require("./annotations_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAnnotationsContext() {
  const context = (0, _react.useContext)(_annotations_context.AnnotationsContext);
  if (!context) {
    throw new Error('Missing Annotations context provider');
  }
  return context;
}