"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanLinksTable = SpanLinksTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _locators = require("@kbn/deeplinks-observability/locators");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _formatters = require("../../../../common/utils/formatters");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _service_link = require("../links/apm/service_link");
var _get_span_icon = require("../span_icon/get_span_icon");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SpanLinksTable({
  items
}) {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query: {
      rangeFrom,
      rangeTo,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer/waterfall', '/dependencies/operation');
  const [idActionMenuOpen, setIdActionMenuOpen] = (0, _react.useState)();
  const {
    share: {
      url: {
        locators
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const apmLinkToTransactionByTraceIdLocator = locators.get(_locators.TRANSACTION_DETAILS_BY_TRACE_ID_LOCATOR);
  const columns = [{
    field: 'serviceName',
    name: _i18n.i18n.translate('xpack.apm.spanLinks.table.serviceName', {
      defaultMessage: 'Service name'
    }),
    sortable: true,
    render: (_, {
      details
    }) => {
      if (details) {
        return /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
          serviceName: details.serviceName,
          agentName: details.agentName,
          query: {
            rangeFrom,
            rangeTo,
            kuery: '',
            serviceGroup: '',
            comparisonEnabled,
            environment: details.environment || 'ENVIRONMENT_ALL'
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        css: {
          lineHeight: 1
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "stopSlash",
        size: "m",
        color: "subdued",
        "aria-label": _i18n.i18n.translate('xpack.apm.spanLinks.table.serviceName.unknown.tooltip.ariaLabel', {
          defaultMessage: 'Icon tooltip for unknown service name'
        }),
        content: _i18n.i18n.translate('xpack.apm.spanLinks.table.serviceName.unknown.tooltip', {
          defaultMessage: 'This span has not yet been completed, please check again in a while.'
        })
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.apm.spanLinks.table.serviceName.unknown', {
        defaultMessage: 'Unknown'
      })));
    }
  }, {
    field: 'spanId',
    name: _i18n.i18n.translate('xpack.apm.spanLinks.table.span', {
      defaultMessage: 'Span'
    }),
    sortable: true,
    render: (_, {
      spanId,
      traceId,
      details
    }) => {
      if (details) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "xs",
          responsive: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: (0, _get_span_icon.getSpanIcon)(details.spanType, details.spanSubtype),
          size: "l"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmColumnsLink",
          href: details.transactionId ? router.link('/link-to/transaction/{transactionId}', {
            path: {
              transactionId: details.transactionId
            },
            query: {
              waterfallItemId: spanId
            }
          }) : apmLinkToTransactionByTraceIdLocator === null || apmLinkToTransactionByTraceIdLocator === void 0 ? void 0 : apmLinkToTransactionByTraceIdLocator.getRedirectUrl({
            traceId,
            rangeFrom,
            rangeTo,
            waterfallItemId: spanId
          })
        }, details.spanName)));
      }
      return `${traceId}-${spanId}`;
    }
  }, {
    field: 'duration',
    name: _i18n.i18n.translate('xpack.apm.spanLinks.table.spanDuration', {
      defaultMessage: 'Span duration'
    }),
    sortable: true,
    width: '150',
    render: (_, {
      details
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, (0, _formatters.asDuration)(details === null || details === void 0 ? void 0 : details.duration));
    }
  }, {
    field: 'actions',
    name: 'Actions',
    width: '100',
    render: (_, {
      spanId,
      traceId,
      details
    }) => {
      const id = `${traceId}:${spanId}`;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "data-test-subj": "apmColumnsButton",
          "aria-label": _i18n.i18n.translate('xpack.apm.spanLinks.table.actions.edit.ariaLabel', {
            defaultMessage: 'Edit'
          }),
          iconType: "boxesHorizontal",
          onClick: () => {
            setIdActionMenuOpen(id);
          }
        }),
        isOpen: idActionMenuOpen === id,
        closePopover: () => {
          setIdActionMenuOpen(undefined);
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "s"
      }, (details === null || details === void 0 ? void 0 : details.transactionId) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmColumnsGoToTraceLink",
        href: router.link('/link-to/transaction/{transactionId}', {
          path: {
            transactionId: details.transactionId
          }
        })
      }, _i18n.i18n.translate('xpack.apm.spanLinks.table.actions.goToTraceDetails', {
        defaultMessage: 'Go to trace'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: traceId
      }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "aria-label": _i18n.i18n.translate('xpack.apm.spanLinks.table.actions.copyParentTraceId.ariaLabel', {
          defaultMessage: 'Copy parent trace id'
        }),
        "data-test-subj": "apmColumnsCopyParentTraceIdButton",
        onClick: () => {
          copy();
          setIdActionMenuOpen(undefined);
        },
        flush: "both"
      }, _i18n.i18n.translate('xpack.apm.spanLinks.table.actions.copyParentTraceId', {
        defaultMessage: 'Copy parent trace id'
      })))), (details === null || details === void 0 ? void 0 : details.transactionId) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmColumnsGoToSpanDetailsLink",
        href: router.link('/link-to/transaction/{transactionId}', {
          path: {
            transactionId: details.transactionId
          },
          query: {
            waterfallItemId: spanId
          }
        })
      }, _i18n.i18n.translate('xpack.apm.spanLinks.table.actions.goToSpanDetails', {
        defaultMessage: 'Go to span details'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: spanId
      }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "aria-label": _i18n.i18n.translate('xpack.apm.spanLinks.table.actions.copySpanId.ariaLabel', {
          defaultMessage: 'Copy span id'
        }),
        "data-test-subj": "apmColumnsCopySpanIdButton",
        onClick: () => {
          copy();
          setIdActionMenuOpen(undefined);
        },
        flush: "both"
      }, _i18n.i18n.translate('xpack.apm.spanLinks.table.actions.copySpanId', {
        defaultMessage: 'Copy span id'
      }))))));
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    columns: columns,
    sorting: true,
    pagination: true
  });
}