"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploreLogsButton = ExploreLogsButton;
var _react = _interopRequireDefault(require("react"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _logs_explorer_locator_config = require("./logs_explorer_locator_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you ∏may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExploreLogsButton({
  start,
  end,
  kuery
}) {
  const {
    share
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const logsExplorerLocator = share.url.locators.get(_deeplinksObservability.ALL_DATASETS_LOCATOR_ID);
  if (!logsExplorerLocator) {
    return null;
  }
  const {
    logsExplorerLinkProps
  } = (0, _logs_explorer_locator_config.buildLogsExplorerLocatorConfig)({
    locator: logsExplorerLocator,
    from: start,
    to: end,
    kuery
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmExploreLogsButton",
    href: logsExplorerLinkProps.href,
    color: "primary"
  }, _i18n.i18n.translate('xpack.apm.button.exploreLogs', {
    defaultMessage: 'Explore logs'
  }));
}