"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.criticalPathToFlamegraph = criticalPathToFlamegraph;
var _lodash = require("lodash");
var _polished = require("polished");
var _seedrandom = _interopRequireDefault(require("seedrandom"));
var _get_aggregated_critical_path_root_nodes = require("../../../../common/critical_path/get_aggregated_critical_path_root_nodes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lightenColor = (0, _polished.lighten)(0.2);
function criticalPathToFlamegraph(params) {
  let sum = 0;
  const {
    criticalPath,
    colors
  } = params;
  const {
    rootNodes,
    maxDepth,
    numNodes
  } = (0, _get_aggregated_critical_path_root_nodes.getAggregatedCriticalPathRootNodes)(params);

  // include the root node
  const totalSize = numNodes + 1;
  const operationId = new Array(totalSize);
  const countInclusive = new Float64Array(totalSize);
  const countExclusive = new Float64Array(totalSize);
  const label = new Array(totalSize);
  const position = new Float32Array(totalSize * 2);
  const size = new Float32Array(totalSize);
  const color = new Float32Array(totalSize * 4);

  // eslint-disable-next-line guard-for-in
  for (const nodeId in criticalPath.timeByNodeId) {
    const count = criticalPath.timeByNodeId[nodeId];
    sum += count;
  }
  let maxValue = 0;
  let index = 0;
  const availableColors = colors.map(vizColor => {
    const rgb = (0, _polished.parseToRgb)(lightenColor(vizColor));
    return [rgb.red / 255, rgb.green / 255, rgb.blue / 255, 1];
  });
  const pickColor = (0, _lodash.memoize)(identifier => {
    const idx = Math.abs((0, _seedrandom.default)(identifier).int32()) % availableColors.length;
    return availableColors[idx];
  });
  function addNodeToFlamegraph(node, x, y) {
    var _operationMetadata, _operationMetadata2, _operationMetadata3;
    let nodeOperationId;
    let nodeLabel;
    let operationMetadata;
    if (node.nodeId === 'root') {
      nodeOperationId = '';
      nodeLabel = 'root';
    } else {
      nodeOperationId = criticalPath.operationIdByNodeId[node.nodeId];
      operationMetadata = criticalPath.metadata[nodeOperationId];
      nodeLabel = operationMetadata['processor.event'] === 'transaction' ? operationMetadata['transaction.name'] : operationMetadata['span.name'];
    }
    operationId[index] = nodeOperationId;
    countInclusive[index] = node.countInclusive;
    countExclusive[index] = node.countExclusive;
    label[index] = nodeLabel;
    position[index * 2] = x / maxValue;
    position[index * 2 + 1] = 1 - (y + 1) / (maxDepth + 1);
    size[index] = node.countInclusive / maxValue;
    const identifier = ((_operationMetadata = operationMetadata) === null || _operationMetadata === void 0 ? void 0 : _operationMetadata['processor.event']) === 'transaction' ? operationMetadata['transaction.type'] : ((_operationMetadata2 = operationMetadata) === null || _operationMetadata2 === void 0 ? void 0 : _operationMetadata2['span.subtype']) || ((_operationMetadata3 = operationMetadata) === null || _operationMetadata3 === void 0 ? void 0 : _operationMetadata3['span.type']) || '';
    color.set(pickColor(identifier), index * 4);
    index++;
    let childX = x;
    node.children.forEach(child => {
      addNodeToFlamegraph(child, childX, y + 1);
      childX += child.countInclusive;
    });
  }
  const root = {
    children: rootNodes,
    nodeId: 'root',
    countExclusive: 0,
    countInclusive: (0, _lodash.sumBy)(rootNodes, 'countInclusive')
  };
  maxValue = root.countInclusive;
  addNodeToFlamegraph(root, 0, 0);
  return {
    viewModel: {
      value: countInclusive,
      label,
      color,
      position0: position,
      position1: position,
      size0: size,
      size1: size
    },
    operationId,
    countExclusive,
    sum
  };
}