"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingFlyout = AlertingFlyout;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _lib = require("@kbn/response-ops-rule-form/lib");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _get_initial_alert_values = require("../../utils/get_initial_alert_values");
var _use_service_name = require("../../../../hooks/use_service_name");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_time_range = require("../../../../hooks/use_time_range");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertingFlyout(props) {
  const {
    addFlyoutVisible,
    setAddFlyoutVisibility,
    ruleType
  } = props;
  const serviceName = (0, _use_service_name.useServiceName)();
  const {
    query,
    path
  } = (0, _use_apm_params.useApmParams)('/*');
  const rangeFrom = 'rangeFrom' in query ? query.rangeFrom : undefined;
  const rangeTo = 'rangeTo' in query ? query.rangeTo : undefined;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo,
    optional: true
  });
  const environment = 'environment' in query ? query.environment : _environment_filter_values.ENVIRONMENT_ALL.value;
  const transactionType = 'transactionType' in query ? query.transactionType : undefined;
  const transactionName = 'transactionName' in query ? query.transactionName : undefined;
  const errorGroupingKey = 'groupId' in path ? path.groupId : undefined;
  const {
    services: {
      triggersActionsUi: {
        ruleTypeRegistry,
        actionTypeRegistry
      },
      ...services
    }
  } = (0, _public.useKibana)();
  const initialValues = (0, _get_initial_alert_values.getInitialAlertValues)(ruleType, serviceName);
  const onCloseAddFlyout = (0, _react.useCallback)(() => setAddFlyoutVisibility(false), [setAddFlyoutVisibility]);
  const addAlertFlyout = (0, _react.useMemo)(() => ruleType && (0, _lib.isValidRuleFormPlugins)(services) && /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...services,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    consumer: _apm_rule_types.APM_SERVER_FEATURE_ID,
    onCancel: onCloseAddFlyout,
    onSubmit: onCloseAddFlyout,
    ruleTypeId: ruleType,
    initialValues: initialValues,
    initialMetadata: {
      environment,
      serviceName,
      ...(ruleType === _ruleDataUtils.ApmRuleType.ErrorCount ? {} : {
        transactionType
      }),
      transactionName,
      errorGroupingKey,
      start,
      end
    },
    shouldUseRuleProducer: true
  }), /* eslint-disable-next-line react-hooks/exhaustive-deps */
  [ruleType, environment, onCloseAddFlyout, ruleTypeRegistry, actionTypeRegistry, serviceName, transactionName, errorGroupingKey, transactionType, environment, start, end]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, addFlyoutVisible && addAlertFlyout);
}