"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.yLabelFormat = exports.isLatencyThresholdRuleType = exports.getAggsTypeFromRule = void 0;
var _common = require("@kbn/observability-plugin/common");
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAggsTypeFromRule = ruleAggType => {
  if (ruleAggType === '95th') return _latency_aggregation_types.LatencyAggregationType.p95;
  if (ruleAggType === '99th') return _latency_aggregation_types.LatencyAggregationType.p99;
  return _latency_aggregation_types.LatencyAggregationType.avg;
};
exports.getAggsTypeFromRule = getAggsTypeFromRule;
const isLatencyThresholdRuleType = ruleTypeId => ruleTypeId === 'apm.transaction_duration';
exports.isLatencyThresholdRuleType = isLatencyThresholdRuleType;
const yLabelFormat = y => {
  return (0, _common.asPercent)(y || 0, 1);
};
exports.yLabelFormat = yLabelFormat;